//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   

//--------------
// tweaks
//--------------
   float3 Ambient={1.0f,0.2f,0.2f};
   float3 LightDir={0.5f,-0.5f,-0.5f};
   float3 LightColor={1.0f,1.0f,1.0f};

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	mipfilter = anisotropic;
	minfilter = anisotropic;
	magfilter = anisotropic;
    };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0; 
	float3 WNormal:TEXCOORD1;
     };


//Output structure for MRT pixel shader
   struct outputMRT
     {
	float4 Col0:COLOR0; 
	float4 Col1:COLOR1; 
	float4 Col2:COLOR2; 
	float4 Col3:COLOR3; 
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
 	OUT.Tex=IN.UV;
	OUT.WNormal=normalize(mul(IN.Normal,World));
	return OUT;
     }

//--------------
// pixel shader
//--------------

    outputMRT PS_MRT(output IN)
     {
	outputMRT OUT;

	float4 Texture=tex2D(Base,IN.Tex); 
	float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));

	OUT.Col0 = Texture*float4(Light+Ambient,1.0f);
	OUT.Col1 = float4((IN.WNormal+1.0)*0.5,1.0f);
	OUT.Col2 = 1.0-Texture*float4(Light+Ambient,1.0f);
	OUT.Col3 = float4(1.0-(IN.WNormal+1.0)*0.5,1.0f);
	return OUT;
     }


    float4 PS_Diffuse(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));
	return Texture*float4(Light+Ambient,1.0f);
     }


//--------------
// techniques   
//--------------
   technique MRT
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS_MRT();
      }
      }

   technique Diffuse
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS_Diffuse();
      }
      }